package gov.va.med.mhv.common.data.converter;

import gov.va.med.mhv.common.api.dto.PatientInformationDTO;
import gov.va.med.mhv.common.data.model.PatientInformation;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

@Component
public class PatientInformationConverter{

	public PatientInformationDTO convertDomainPatientInformation(PatientInformation patientInformation) {
		PatientInformationDTO patientInformationDto = new PatientInformationDTO();

		patientInformationDto.setPatientId(patientInformation.getPatientId());
		patientInformationDto.setUserProfileId(patientInformation.getUserProfileId());
		patientInformationDto.setIcn(patientInformation.getIcn());
		patientInformationDto.setFirstName(patientInformation.getFirstName());
		patientInformationDto.setMiddleName(patientInformation.getMiddleName());
		patientInformationDto.setLastName(patientInformation.getLastName());
		patientInformationDto.setSuffix(patientInformation.getSuffix());
		patientInformationDto.setSsn(patientInformation.getSsn());
		patientInformationDto.setEmail(patientInformation.getEmail());
		patientInformationDto.setBirthDate(patientInformation.getBirthDate());
		patientInformationDto.setUserName(patientInformation.getUserName());
		patientInformationDto.setMhvId(patientInformation.getMhvId());
		patientInformationDto.setIpaStatus(patientInformation.getIpaStatus());
		patientInformationDto.setIpaDate(patientInformation.getIpaDate());
		patientInformationDto.setIpaFacilityInfoId(patientInformation.getIpaFacilityInfoId());
		patientInformationDto.setIpaFacilityInfoName(patientInformation.getIpaFacilityInfoName());
		patientInformationDto.setTreatingFacilityId(patientInformation.getTreatingFacilityId());
		patientInformationDto.setCorrelationStatus(patientInformation.getCorrelationStatus());
		patientInformationDto.setGender(patientInformation.getGender());
		patientInformationDto.setCorrelatedDate(patientInformation.getCorrelatedDate());
		patientInformationDto.setMatchedDate(patientInformation.getMatchedDate());
		patientInformationDto.setMviAuthenticationStatus(patientInformation.getMviAuthenticationStatus());

		return patientInformationDto;
	}

	public PatientInformation convertDTOPatientInformation(PatientInformationDTO patientInformationDto) {
		PatientInformation patientInformation = new PatientInformation();

		patientInformation.setPatientId(patientInformationDto.getPatientId());
		patientInformation.setUserProfileId(patientInformationDto.getUserProfileId());
		patientInformation.setIcn(patientInformationDto.getIcn());
		patientInformation.setFirstName(patientInformationDto.getFirstName());
		patientInformation.setMiddleName(patientInformationDto.getMiddleName());
		patientInformation.setLastName(patientInformationDto.getLastName());
		patientInformation.setSuffix(patientInformationDto.getSuffix());
		patientInformation.setSsn(patientInformationDto.getSsn());
		patientInformation.setEmail(patientInformationDto.getEmail());
		patientInformation.setBirthDate(patientInformationDto.getBirthDate());
		patientInformation.setUserName(patientInformationDto.getUserName());
		patientInformation.setMhvId(patientInformationDto.getMhvId());
		patientInformation.setIpaStatus(patientInformationDto.getIpaStatus());
		patientInformation.setIpaDate(patientInformationDto.getIpaDate());
		patientInformation.setIpaFacilityInfoId(patientInformationDto.getIpaFacilityInfoId());
		patientInformation.setIpaFacilityInfoName(patientInformationDto.getIpaFacilityInfoName());
		patientInformation.setTreatingFacilityId(patientInformationDto.getTreatingFacilityId());
		patientInformation.setCorrelationStatus(patientInformationDto.getCorrelationStatus());
		patientInformation.setGender(patientInformationDto.getGender());
		patientInformation.setCorrelatedDate(patientInformationDto.getCorrelatedDate());
		patientInformation.setMatchedDate(patientInformationDto.getMatchedDate());
		patientInformation.setMviAuthenticationStatus(patientInformationDto.getMviAuthenticationStatus());

		return patientInformation;
	}
	
	public List<PatientInformationDTO> convertList(List<PatientInformation> source) {

		List<PatientInformationDTO> destination = new ArrayList<PatientInformationDTO>();
		for (PatientInformation a : source) {
			destination.add(convertDomainPatientInformation(a));
		}
		return destination;
	}	

}
